#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Inversive KaleidoscopeMod01.fsh  by mla 
//https://www.shadertoy.com/view/.....
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
// Inversive Kaleidoscope
// mla, 2020
//
// <mouse>: move free inversion circle
// c: show circles
// l: show lines
// m: mouse
////////////////////////////////////////////////////////////////////////////////
//prevoid buffer//
const float PI = 3.1415927;
float time;

vec3 hsv2rgb(in vec3 c) {
  vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
  rgb = rgb*rgb*(3.0-2.0*rgb); // cubic smoothing	
  return c.z * mix( vec3(1.0), rgb, c.y);
}

#define key(code) (texelFetch(iChannel3, ivec2((code),2),0).x != 0.0)

const int CHAR_C = 67;
const int CHAR_L = 76;
const int CHAR_M = 77;
const int CHAR_N = 78;
const int CHAR_R = 82;
const int CHAR_S = 83;
const int CHAR_T = 84;
const int CHAR_X = 88;

vec2 invert(vec2 z, vec3 c) {
  z -= c.xy;
  float k = c.z/dot(z,z);
  z *= k;
  z += c.xy;
  return z;
}

bool inside(vec2 z, vec3 c) {
  z -= c.xy;
  return dot(z,z) < abs(c.z);
}

float kfact = 0.8;
float lwidth = 0.01;
vec3 draw(float d, vec3 col, vec3 ccol, float pwidth) {
  pwidth *= 0.1; //0.25;
  col = mix(ccol,col,mix(1.0,smoothstep(0.5*lwidth,max(pwidth,lwidth),d),kfact));
  //col = mix(ccol,col,mix(1.0,smoothstep(-pwidth,pwidth,d-lwidth),kfact));
  return col;

}

vec3 drawcircle(vec2 z, vec3 col, vec3 ccol, vec3 circle) {
  float d = abs(length(z-circle.xy) - sqrt(abs(circle.z)));
  return draw(d,col,ccol,fwidth(z.x));
}

vec3 drawline(vec2 z, vec3 col, vec3 ccol, vec2 line) {
  float d = abs(dot(z,line));
  return draw(d,col,ccol,fwidth(z.x));
}

//end prevoid buffer//

int P = 7;
vec3 getcolor(vec2 z0, vec2 w) {
  z0 += 1e-2;
  vec2 z = z0;
  float r2 = 2.0-cos(time);
  float theta = PI/float(P);
  vec2 l0 = vec2(0,1);
  vec2 l1 = vec2(sin(theta),-cos(theta));
  vec3 c0 = vec3(0,0,r2);
  vec3 c1 = vec3(w,1.0);
  int i, N = 40;
  for (i = 0; i < N; i++) {
    for (int j = 0; j < P; j++) {
      if (dot(z,l0) < 0.0) z = reflect(z,l0);
      else if (dot(z,l1) < 0.0) z = reflect(z,l1);
      else break;
    }
    if (inside(z,c1)) z = invert(z,c1);
    else if (inside(z,c0)) z = invert(z,c0);
    else break;
  }
  if (i == N) return vec3(0);
  vec3 col = vec3(1);
  col = hsv2rgb(vec3(float(i)/10.0,1,1));
  if (!key(CHAR_L)) {
    vec3 ccol = vec3(0);
    col = drawline(z,col,ccol,l0);
    col = drawline(z,col,ccol,l1);
    col = drawcircle(z,col,ccol,c0);
    col = drawcircle(z,col,ccol,c1);
  }
  if (!key(CHAR_C)) {
    vec3 ccol = vec3(1);
    col = drawline(z0,col,ccol,l0);
    col = drawline(z0,col,ccol,l1);
    col = drawcircle(z0,col,ccol,c0);
    col = drawcircle(z0,col,ccol,c1);
  }
  return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  float AA = 2.0;
  vec3 color = vec3(0);
  float scale = 2.0;
  time = iTime - 5.0;
  for (float i = 0.0; i < AA; i++) {
    for (float j = 0.0; j < AA; j++) {
      vec2 z = scale*(2.0*(fragCoord+vec2(i,j)/AA)-iResolution.xy)/iResolution.y;
      vec2 w = vec2(2.0,0.25)+vec2(-0.25*sin(0.618*time),0.5*cos(0.618*time));
      if (iMouse.x > 0.0 && !key(CHAR_M)) w = scale*(2.0*iMouse.xy-iResolution.xy)/iResolution.y;
      color += getcolor(z,w);
    }
  }
  color /= AA*AA;
  color = pow(color,vec3(0.4545));
  fragColor = vec4(color,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

